* Replication files for
* "Capital Reallocation and the Cyclicality of Aggregate Productivity" by Russ Cooper & Immo Schott
* Prepared: May 2023

* ONLY EXECUTE THIS DO FILE IF YOU WANT TO OVERWRITE THE EXISTING DATA
* WITH UPDATED VERSION OF COMPUSTAT ETC.

* This file loads the data (Compustat, external aggregate statistics), performs data cleaning
* and analysis, and saves the data so as to replicate the tables and figures.
* To replciate this code with your own Compustat file, please put a file CompustatY.dta
* into the data folder denoted by cspath below.

**********************************************************************
****** PLEASE SET YOUR LOCAL WORKING DIRECTORY HERE *****
* This is the path where this do file is located:
global path ".../Replication package/Data/Data setup"
* This is the path where your local CompustatY.dta is located
global cspath "..."
* This is the file path of the replication files' data folder:
global datapath ".../Replication package/Data"
* This is the file path of the replication files' main folder:
global mainpath ".../Replication package"
cd "$path"
**********************************************************************
**********************************************************************

clear

* Import aggregate data for business cycle statistics
qui do aux/agg_data_import.do

* Import aggregate GDP and TFP series
qui do aux/agg_prod_import.do

* Import price data for deflating purposes and TFP estimation
qui do aux/price_data_import.do

* Import Compustat data and perform basic cleaning
qui do aux/Compustat_data_import.do
compress
* Save a copy
save Compustat_coopimmo.dta, replace

* Use the Compustat data to compute reallocation measures at the firm-level
qui do aux/Reallocation_vars.do
* Main new variables:
* R = Capital reallocation
* adj_R = Dummy for whether or not a firm adjusts capital
* RK = Capital reallocation over total firm-level capital

* Compute productivity measures at the firm-level
qui do aux/Productivity_vars.do
* Main new variables:
* TFP = Productivity from OP estimation
* APK = Y / K

* Compute value-added weighted dispersion of log APK and log TFP and reallocation rates
qui do aux/dispersion.do
* Main new variables:
* Dispersion: sd_TFP, sd_APK, sd_RK

* Cleaning
drop sic y l k i i2 k2 ik gvkey at invt ppegt fic naics NAICS 
drop Compustatage inv_def gdp_def value_added exit ind_year capital labor va_share

* Save a micro-level dataset 
compress
save "$datapath/microdata_coopimmo.dta", replace

* Create some macro moments and save an aggregate data set
qui do aux/macro_data.do

erase Compustat_coopimmo.dta

**********************************************************************
**********************************************************************
**********************************************************************

* At this point, there should be five newly created dataset in the "Data" folder
* RBC_data.dta
* prices_updated.dta
* productivity_data.dta
* macrodata_coopimmo.dta
* microdata_coopimmo.dta


* Create mini data sets for every table and figure
* drawing either on the micro- or macro datasets.
* These are saved either in Figures_data or in Tables_data

* Set up data for Figure 1
qui do aux/Figures/data_Figure1.do
* Set up data for Figure 2
qui do aux/Figures/data_Figure2.do
* Set up data for Figure 7
qui do aux/Figures/data_Figure7.do


* Set up data for Table 2
qui do aux/Tables/data_Table2.do
* Set up data for Table 3
qui do aux/Tables/data_Table3.do
* Set up data for Table 4
qui do aux/Tables/data_Table4.do


erase "$datapath/macrodata_coopimmo.dta"
erase "$datapath/microdata_coopimmo.dta"



